{********************************************
; File: Controls.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT CONTROLS;

INTERFACE

USES TYPES,QUICKDRAW,EVENTS;

CONST
{ Axis Parameters }
noConstraint = $0000;  { No constraint on movement. }
hAxisOnly = $0001;  { Horizontal axis only. }
vAxisOnly = $0002;  { Vertical axis only. }

{ CtlFlag }
simpRound = $0000;  { Simple button flag }
upFlag = $0001;  { Scroll bar flag.  }
boldButton = $0001;  { Bold round cornered outlined button. }
simpBRound = $0001;  { Simple button flag }
downFlag = $0002;  { Scroll bar flag. }
simpSquare = $0002;  { Simple button flag }
simpDropSquare = $0003;  { Simple button flag }
leftFlag = $0004;  { Scroll bar flag. }
rightFlag = $0008;  { Scroll bar flag. }
dirScroll = $0010;  { Scroll bar flag. }
horScroll = $0010;  { Scroll bar flag. }
family = $007F;  { Mask for radio button family number }
ctlInVis = $0080;  { invisible mask for any type of control  }
fCallWindowMgr = $0001;  { Control Template flag value }
fSubstituteText = $0002;
fSubTextType = $0001;
inListBox = $88;

{ CtlProc Codes }
simpleProc = $00000000;
checkProc = $02000000;
radioProc = $04000000;
scrollProc = $06000000;
growProc = $08000000;

{ DefProc Commands }
drawCtl = $0000;  { Draw control command. }
calcCRect = $0001;  { Compute drag RECT command. }
testCtl = $0002;  { Hit test command. }
initCtl = $0003;  { Initialize command. }
dispCtl = $0004;  { Dispose command. }
posCtl = $0005;  { Move indicator command. }
thumbCtl = $0006;  { Compute drag parameters command. }
dragCtl = $0007;  { Drag command. }
autoTrack = $0008;  { Action command. }
newValue = $0009;  { Set new value command. }
setParams = $000A;  { Set new parameters command. }
moveCtl = $000B;  { Move command. }
recSize = $000C;  { Return record size command. }
ctlHandleEvent = $000D;  { Handle a keystroke or menu selection }
ctlChangeTarget = $000E;  { Issued when control's target status has changed }
ctlChangeBounds = $000F;  { Issued when control's boundary rectangle has changed }
ctlWindChangeSize = $0010;  { Window has been grown or zoomed }
ctlHandleTab = $0011;  { Control has been tabbed to }
ctlNotifyMultiPart = $0012;  { A multipart control has been hidden, drawn or shown }
ctlWinStateChange = $0013;  { Window state has changed }

{ hiliteState Codes }
noHilite = $0000;  { Param to HiliteControl }
inactiveHilite = $00FF;  { Param to HiliteControl }

{ PartCode Numbers }
noPart = $0000;
simpleButton = $0002;
checkBox = $0003;
radioButton = $0004;
upArrow = $0005;
downArrow = $0006;
pageUp = $0007;
pageDown = $0008;
growBox = $000A;
thumb = $0081;

{ moreFlags Codes }
fCtlTarget = $8000;  { is current target of typing commands }
fCtlCanBeTarget = $4000;  { can be made the target control }
fCtlWantEvent = $2000;  { control can be called view SendEventToCtl }
fCtlWantsEvent = $2000;  { control can be called view SendEventToCtl }
fCtlWantEvents = $2000;  { control can be called view SendEventToCtl }
fCtlWantsEvents = $2000;  { control can be called view SendEventToCtl }
fCtlProcRefNotPtr = $1000;  { set = ID of defproc, clear = pointer to defproc }
fCtlTellAboutSize = $0800;  { set if ctl needs notification when size of owning window changes }
fCtlIsMultiPart = $0400;  { set if ctl needs notification to be hidden }
fMenuDefIsText = $0004;
colorDescriptor = $000C;  { indicates type of reference in colorRef }
styleDescriptor = $0003;  { indicates type of reference in styleRef }

{ Ctl Verbs }
titleIsPtr = $00;
titleIsHandle = $01;
titleIsResource = $02;
colorTableIsPtr = $00;
colorTableIsHandle = $04;
colorTableIsResource = $08;
ctlHideCtl = $12;

{ InputVerb Codes }
singlePtr = $0000;
singleHandle = $0001;
singleResource = $0002;
ptrToPtr = $0003;
ptrToHandle = $0004;
ptrToResource = $0005;
handleToPtr = $0006;
handleToHandle = $0007;
handleToResource = $0008;
resourceToResource = $0009;

{ ProcRefs }
simpleButtonControl = $80000000;
checkControl = $82000000;
radioControl = $84000000;
scrollBarControl = $86000000;
growControl = $88000000;
statTextControl = $81000000;
editLineControl = $83000000;
editTextControl = $85000000;
popUpControl = $87000000;
listControl = $89000000;
iconButtonControl = $07FF0001;
pictureControl = $8D000000;

{ Error Codes }
wmNotStartedUp = $1001;  { Window manager was not initialized }
cmNotInitialized = $1002;  { Control manager was not initialized }
noCtlInList = $1003;  { Control not in window list }
noCtlError = $1004;  { no controls in window }
noSuperCtlError = $1005;  { no super controls in window }
noCtlTargetError = $1006;  { no target super control }
notSuperCtlError = $1007;  { action can only be done on super control }
canNotBeTargetError = $1008;  { conrol cannot be made target }
noSuchIDError = $1009;  { specified ID cannot be found }
tooFewParmsError = $100A;  { not enough params specified }
noCtlToBeTargetError = $100B;  { NextCtl call, no ctl could be target }
noFrontWindowError = $100C;  { there is no front window }

{ displayMode flags }
selectedIcon = $0001;
openIcon = $0002;
offline = $0004;

{ listType values }
fListString = $0001;
fListSelect = $0002;
fListScrollBar = $0004;

{ PopUp control flag values }
fRightJustifyResult = $0001;
fRightJustifyTitle = $0002;
fInWindowOnly = $0004;
fDontDrawResult = $0008;
fDontDrawTitle = $0010;
fDontHiliteTitle = $0020;
fType2PopUp = $0040;

TYPE
{$IFC UNDEFINED WindowPtr }
WindowPtr = GrafPortPtr ;
{$SETC WindowPtr := 0 }
{$ENDC}


BarColorsHndl = ^BarColorsPtr;
BarColorsPtr = ^BarColors;
BarColors = RECORD
    barOutline : Integer; { color for outlining bar, arrows, and thumb }
    barNorArrow : Integer; { color of arrows when not highlighted }
    barSelArrow : Integer; { color of arrows when highlighted }
    barArrowBack : Integer; { color of arrow box's background }
    barNorThumb : Integer; { color of thumb's background when not highlighted }
    barSelThumb : Integer; { color of thumb's background when highlighted }
    barPageRgn : Integer; { color and pattern page region: high byte - 1= dither, 0 = solid }
    barInactive : Integer; { color of scroll bar's interior when inactive }
END;

BoxColorsHndl = ^BoxColorsPtr;
BoxColorsPtr = ^BoxColors;
BoxColors = RECORD
    boxReserved : Integer; { reserved }
    boxNor : Integer; { color of box when not checked }
    boxSel : Integer; { color of box when checked }
    boxTitle : Integer; { color of check box's title }
END;

BttnColorsHndl = ^BttnColorsPtr;
BttnColorsPtr = ^BttnColors;
BttnColors = RECORD
    bttnOutline : Integer; { color of outline }
    bttnNorBack : Integer; { color of background when not selected }
    bttnSelBack : Integer; { color of background when selected }
    bttnNorText : Integer; { color of title's text when not selected }
    bttnSelText : Integer; { color of title's text when selected }
END;

CtlRecHndlPtr = ^CtlRecHndl;
CtlRecHndl = ^CtlRecPtr;
CtlRecPtr = ^CtlRec;
CtlRec = PACKED RECORD
    ctlNext : CtlRecHndl; { Handle of next control. }
    ctlOwner : WindowPtr; { Pointer to control's window. }
    ctlRect : Rect; { Enclosing rectangle. }
    ctlFlag : Byte; { Bit flags. }
    ctlHilite : Byte; { Highlighted part. }
    ctlValue : Integer; { Control's value. }
    ctlProc : LongProcPtr; { Control's definition procedure. }
    ctlAction : LongProcPtr; { Control's action procedure. }
    ctlData : Longint; { Reserved for CtrlProc's use. }
    ctlRefCon : Longint; { Reserved for application's use. }
    ctlColor : Ptr; { Pointer to appropriate color table. }
    ctlReserved : PACKED ARRAY[1..16] OF Byte; { Reserved for future expansion }
    ctlID : Longint;
    ctlMoreFlags : Integer;
    ctlVersion : Integer;
END;

LimitBlkHndl = ^LimitBlkPtr;
LimitBlkPtr = ^LimitBlk;
LimitBlk = RECORD
    boundRect : Rect; { Drag bounds. }
    slopRect : Rect; { Cursor bounds. }
    axisParam : Integer; { Movement constrains. }
    dragPatt : Ptr; { Pointer to 32 byte Pattern for drag outline. }
END;

RadioColorsHndl = ^RadioColorsPtr;
RadioColorsPtr = ^RadioColors;
RadioColors = RECORD
    radReserved : Integer; { reserved }
    radNor : Integer; { color of radio button when off }
    radSel : Integer; { color of radio button when on }
    radTitle : Integer; { color of radio button's title text }
END;

KeystrokeRec = PACKED RECORD
    key1 : Byte;
    key2 : Byte;
    keyModifiers : Integer;
    keyCareBits : Integer;
END;

ControlTemplate = RECORD
    pCount : Integer;
    ID : Longint;
    rect : Rect;
    procRef : Longint;
    flag : Integer;
    moreFlags : Integer;
    refCon : Longint;
END;

SimpleButtonTemplate = RECORD
    ctlTemplate : ControlTemplate;
    titleRef : Ref;
    colorTableRef : Ref;
    keyEquivalent : KeystrokeRec;
END;

CheckBoxTemplate = RECORD
    ctlTemplate : ControlTemplate;
    titleRef : Ref;
    initalValue : Integer;
    colorTableRef : Ref;
    keyEquivalent : KeystrokeRec;
END;

IconButtonTemplate = RECORD
    ctlTemplate : ControlTemplate;
    iconRef : Ref;
    titleRef : Ref;
    colorTableRef : Ref;
    displayMode : Integer;
    keyEquivalent : KeystrokeRec;
END;

LineEditTemplate = RECORD
    ctlTemplate : ControlTemplate;
    maxSize : Integer;
    defaultRef : Ref;
END;

ListTemplate = RECORD
    ctlTemplate : ControlTemplate;
    listSize : Integer;
    listView : Integer;
    listType : Integer;
    listStart : Integer;
    listDraw : ProcPtr;
    listMemHeight : Integer;
    listMemSize : Integer;
    listRef : Ref;
    colorTableRef : Ref;
END;

PictureTemplate = RECORD
    ctlTemplate : ControlTemplate;
    pictureRef : Ref;
END;

PopupTemplate = RECORD
    ctlTemplate : ControlTemplate;
    titleWidth : Integer;
    menuRef : Ref;
    initialValue : Integer;
    colorTableRef : Ref;
END;

RadioButtonTemplate = RECORD
    ctlTemplate : ControlTemplate;
    titleRef : Ref;
    initalValue : Integer;
    colorTableRef : Ref;
    keyEquivalent : KeystrokeRec;
END;

ScrollBarTemplate = RECORD
    ctlTemplate : ControlTemplate;
    maxSize : Integer;
    viewSize : Integer;
    initalValue : Integer;
    colorTableRef : Ref;
END;

SizeBoxTemplate = RECORD
    ctlTemplate : ControlTemplate;
    colorTableRef : Ref;
END;

StaticTextTemplate = RECORD
    ctlTemplate : ControlTemplate;
    textRef : Ref;
    textSize : Integer;
    just : Integer;
END;

TextEditTemplate = RECORD
    ctlTemplate : ControlTemplate;
    textFlags : Longint;
    indentRect : Rect;
    vertBar : CtlRecHndl;
    vertAmount : Integer;
    horzBar : CtlRecHndl;
    horzAmount : Integer;
    styleRef : Ref;
    textDescriptor : Integer;
    textRef : Ref;
    textLength : Longint;
    maxChars : Longint;
    maxLines : Longint;
    maxCharsPerLine : Integer;
    maxHeight : Integer;
    colorRef : Ref;
    drawMode : Word;
    filterProcPtr : ProcPtr;
END;

FUNCTION  CallCtlDefProc ( ctlHandle:CtlRecHndl; ctlMessage:Integer; ctlParam:Longint) : Longint ;
FUNCTION  CMLoadResource ( resourceType:Integer; resourceID:Longint) : Handle ;
PROCEDURE CMReleaseResource ( resourceType:Integer; resourceID:Longint)  ;
PROCEDURE CtlBootInit   ;
PROCEDURE CtlNewRes   ;
PROCEDURE CtlReset   ;
PROCEDURE CtlShutDown   ;
PROCEDURE CtlStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION  CtlStatus  : Boolean ;
FUNCTION  CtlVersion  : Integer ;
PROCEDURE DisposeControl ( theControlHandle:CtlRecHndl)  ;
PROCEDURE DragControl ( startX:Integer; startY:Integer; limitRectPtr:Rect; slopRectPtr:Rect; dragFlag:Integer; theControlHandle:CtlRecHndl)  ;
FUNCTION  DragRect ( actionProcPtr:VoidProcPtr; dragPatternPtr:Pattern; startX:Integer; startY:Integer;VAR dragRectPtr:Rect; limitRectPtr:Rect; slopRectPtr:Rect; dragFlag:Integer) : Point ;
PROCEDURE DrawControls ( theWindowPtr:WindowPtr)  ;
PROCEDURE DrawOneCtl ( theControlHandle:CtlRecHndl)  ;
PROCEDURE EraseControl ( theControlHandle:CtlRecHndl)  ;
FUNCTION  FindControl (VAR foundCtl:CtlRecHndl; pointX:Integer; pointY:Integer; theWindowPtr:WindowPtr) : Integer ;
FUNCTION  FindTargetCtl  : CtlRecHndl ;
PROCEDURE FutzCtls   ;
FUNCTION  GetCtlAction ( theControlHandle:CtlRecHndl) : LongProcPtr ;
FUNCTION  GetCtlDPage  : Integer ;
FUNCTION  GetCtlHandleFromID ( ctlWindowPtr:WindowPtr; ctlID:Longint) : CtlRecHndl ;
FUNCTION  GetCtlID ( ctlHandle:CtlRecHndl) : Longint ;
FUNCTION  GetCtlMoreFlags ( ctlHandle:CtlRecHndl) : Integer ;
FUNCTION  GetCtlParamPtr  : Ptr ;
FUNCTION  GetCtlParams ( theControlHandle:CtlRecHndl) : Longint ;
FUNCTION  GetCtlRefCon ( theControlHandle:CtlRecHndl) : Longint ;
FUNCTION  GetCtlTitle ( theControlHandle:CtlRecHndl) : Ptr ;
FUNCTION  GetCtlValue ( theControlHandle:CtlRecHndl) : Integer ;
FUNCTION  GrowSize  : Longint ;
PROCEDURE HideControl ( theControlHandle:CtlRecHndl)  ;
PROCEDURE HiliteControl ( hiliteState:Integer; theControlHandle:CtlRecHndl)  ;
PROCEDURE InvalCtls ( ctlWindowPtr:WindowPtr)  ;
PROCEDURE KillControls ( theWindowPtr:WindowPtr)  ;
FUNCTION  MakeNextCtlTarget  : CtlRecHndl ;
PROCEDURE MakeThisCtlTarget ( ctlToBeTarget:CtlRecHndl)  ;
PROCEDURE MoveControl ( newX:Integer; newY:Integer; theControlHandle:CtlRecHndl)  ;
FUNCTION  NewControl ( theWindowPtr:WindowPtr; boundsRectPtr:Rect; titlePtr:Ptr; flag:Integer; value :Integer; param1:Integer; param2:Integer; defProcPtr:LongProcPtr; refCon:Longint; newColorTablePtr:ColorTablePtr) : CtlRecHndl ;
FUNCTION  NewControl2 ( ownerPtr:WindowPtr; inputDesc:RefDescriptor; inputRef:Ref) : CtlRecHndl ;
PROCEDURE NotifyControls ( notifyMask:Integer; message:Integer; notifyParam:Longint; window:WindowPtr)  ;
PROCEDURE NotifyCtls ( moreFlagsMask:Integer; ctlMessage:Integer; ctlParam:Longint; theWindowPtr:WindowPtr)  ;
FUNCTION  SendEventToCtl ( targetOnlyFlag:Integer; ctlWindowPtr:WindowPtr; eTaskRecPtr:Ptr) : Boolean ;
PROCEDURE SetCtlAction ( newActionPtr:LongProcPtr; theControlHandle:CtlRecHndl)  ;
FUNCTION  SetCtlIcons ( newFontHandle:FontHndl) : FontHndl ;
PROCEDURE SetCtlID ( newID:Longint; ctlHandle:CtlRecHndl)  ;
PROCEDURE SetCtlMoreFlags ( newMoreFlags:Integer; ctlHandle:CtlRecHndl)  ;
PROCEDURE SetCtlParamPtr ( SubArrayPtr:Ptr)  ;
PROCEDURE SetCtlParams ( param2:Integer; param1:Integer; theControlHandle:CtlRecHndl)  ;
PROCEDURE SetCtlRefCon ( newRefCon:Longint; theControlHandle:CtlRecHndl)  ;
PROCEDURE SetCtlTitle ( title:Str255; theControlHandle:CtlRecHndl)  ;
PROCEDURE SetCtlValue ( curValue:Integer; theControlHandle:CtlRecHndl)  ;
PROCEDURE ShowControl ( theControlHandle:CtlRecHndl)  ;
FUNCTION  TestControl ( pointX:Integer; pointY:Integer; theControlHandle:CtlRecHndl) : Integer ;
FUNCTION  TrackControl ( startX:Integer; startY:Integer; actionProcPtr:LongProcPtr; theControlHndl:CtlRecHndl) : Integer ;

IMPLEMENTATION

END.
